package com.esv.freight.customer.module.pay.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户银联支付订单表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-30 13:41:51
 */
@Data
@TableName("customer_unionpay_order")
public class CustomerUnionpayOrderEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 客户ID
	 */
	private Long customerId;
	/**
	 * 商户代码(网络货运平台在支付平台的商户号)
	 */
	private String merId;
	/**
	 * 账单号
	 */
	private String billId;
	/**
	 * 账单描述
	 */
	private String billDesc;
	/**
	 * 请求支付平台订单发送时间
	 */
	private String txnTime;
	/**
	 * 交易金额(单位为分)
	 */
	private Long txnAmt;
	/**
	 * 支付平台受理订单号
	 */
	private String tn;
	/**
	 * 订单状态：1-支付中、2-支付结果确认中、3-支付成功、4-支付失败
	 */
	private Integer orderStatus;
	/**
	 * 请求银联查询次数，最多6次
	 */
	private Integer queryCount;
	/**
	 * 银联交易状态
	 */
	private String origRespCode;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.UPDATE)
	private Date updateTime;

}
