package com.esv.freight.customer.module.vehicle.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.vehicle.vo.VehicleListVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/27 13:40
 * @version:1.0
 */
@Data
public class VehicleListVO {

    /**
     *
     */
    private Long id;
    /**
     * 承运商名称
     */
    private String carrierName;
    /**
     * 车牌号
     */
    private String licenseNumber;
    /**
     * 车辆状态：1-正常、2-停用
     */
    private Integer vehicleStatus;
    /**
     * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private Integer auditStatus;
    /**
     * 车辆类型(字典表)
     */
    private Integer vehicleType;
    /**
     * 二级车辆类型(字典表)
     */
    private Integer vehicleType2;
    /**
     * 行驶证档案编号
     */
    private String vehicleLicenseNumber;
    /**
     * 道路运输证号
     */
    private String roadCertificateNumber;
    /**
     * 核定载质量(吨)
     */
    private BigDecimal loadCapacity;
    /**
     * 创建来源：1-平台创建、2-司机创建
     */
    private Integer sourceType;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 创建时间
     */
    private Long createTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
