package com.esv.freight.customer.module.contract.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.form.ContractOnlineRecordForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 16:52
 * @version:1.0
 */
@Data
public class ContractOnlineRecordForm {

    /**
     *
     */
    private Long id;
    /**
     * 合同类型：1-货主与平台合同、2-司机与平台合同
     */
    private Integer contractType;
    /**
     * 合同文件ID
     */
    private String contractFileId;
    /**
     * 合同文件URL
     */
    private String contractFileUrl;
    /**
     * 合同编号
     */
    @Length(max = 64, message = "参数contractNumber长度不合法", groups = {ValidatorDetail.class})
    @NotBlank(message = "参数contractNumber不能为空", groups = {ValidatorDetail.class})
    private String contractNumber;
    /**
     * 业务编号（订单号或运单号）
     */
    private String businessNumber;
    /**
     * 客户ID
     */
    private Long customerId;
    /**
     * 客户（货主或司机）签订时间
     */
    private Long customerSignTime;
    /**
     * 平台签订时间
     */
    private Long platformSignTime;
    /**
     * 合同签订完成：1-是，2-否
     */
    private Integer signComplete;
    /**
     * 合同生效时间
     */
    private Long effectiveTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
