package com.esv.freight.customer.module.driver.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.vo.VehicleDriverListVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/07 16:02
 * @version:1.0
 */
@Data
public class VehicleDriverListVO {

    /**
     *
     */
    private Long id;
    /**
     * 登录帐号，司机手机号
     */
    private String account;
    /**
     * 姓名
     */
    private String name;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private Integer accountStatus;
    /**
     * 创建来源：1-平台创建、2-自行注册
     */
    private Integer sourceType;
    /**
     * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private Integer auditStatus;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
