package com.esv.freight.customer.module.vehicle.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 车辆附件表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-26 11:21:07
 */
@Data
@TableName("vehicle_attachment")
public class AttachmentEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 承运商ID
	 */
	private Long carrierId;
	/**
	 * 车辆ID
	 */
	private Long vehicleId;
	/**
	 * 车头照片URL
	 */
	private String vehicleHeadUrl;
	/**
	 * 人车合照URL
	 */
	private String vehicleHeadPersonUrl;
	/**
	 * 行驶证正面URL
	 */
	private String vehicleLicenseFrontUrl;
	/**
	 * 行驶证背面URL
	 */
	private String vehicleLicenseBackUrl;
	/**
	 * 道路运输证正面URL
	 */
	private String roadCertificateFrontUrl;
	/**
	 * 挂靠声明URL
	 */
	private String attachedStatementUrl;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
