package com.esv.freight.customer.module.vehicle.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.vehicle.form.VehicleInfoForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.vehicle.controller.VehicleControllerEditTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/26 15:27
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class VehicleControllerEditTest extends BaseTestController {

    /**
     * 编辑车辆信息
     **/
    @Test
    public void a1_edit_success_test() throws Exception {
        String url = "/carrier/vehicle/edit";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setId(1L);
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12311");
        form.setLicenseType(2); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(14); // 车辆类型(字典表)：14-微型货车
        form.setVehicleType2(1402); // 二级车辆类型(字典表)：1402-微型厢式货车
        form.setLicenseColor(1); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(4800);
        form.setVehicleWidth(1900);
        form.setVehicleHeight(2100);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210102123456");
        form.setLoadCapacity(new BigDecimal("4.0"));
        form.setTotalMass(new BigDecimal("5.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505511");
        form.setBrandModel("京杯");
        form.setEngineNumber("S12345678");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210103");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_001.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_001.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_001.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_001.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_001.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_001.jpg");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 编辑车辆信息：无效的车辆ID
     **/
    @Test
    public void a2_edit_vehicle_wrong_id_success_test() throws Exception {
        String url = "/carrier/vehicle/edit";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setId(99999L);
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12311");
        form.setLicenseType(2); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(14); // 车辆类型(字典表)：14-微型货车
        form.setVehicleType2(1402); // 二级车辆类型(字典表)：1402-微型厢式货车
        form.setLicenseColor(1); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(4800);
        form.setVehicleWidth(1900);
        form.setVehicleHeight(2100);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210102123456");
        form.setLoadCapacity(new BigDecimal("4.0"));
        form.setTotalMass(new BigDecimal("5.1"));

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 编辑车辆信息：车牌号已存在
     **/
    @Test
    public void a3_edit_vehicle_wrong_licenseNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/edit";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setId(1L);
        form.setLicenseNumber("辽A12302");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 编辑车辆信息：行驶证档案编号已存在
     **/
    @Test
    public void a4_edit_vehicle_wrong_vehicleLicenseNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/edit";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setId(1L);
        form.setVehicleLicenseNumber("210101123457");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 编辑车辆信息：道路运输证号已存在
     **/
    @Test
    public void a5_edit_vehicle_wrong_roadCertificateNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/edit";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setId(1L);
        form.setRoadCertificateNumber("510184010714");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

    /**
     * 编辑车辆信息：道路运输证号，4.5吨及以下普货车辆可以为空
     **/
    @Test
    public void a6_edit_vehicle_wrong_roadCertificateNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/edit";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setId(1L);
        form.setLoadCapacity(new BigDecimal("5.0"));

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }

}
