package com.esv.freight.customer.module.pay.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.module.pay.form.CustomerPayOrderForm;
import com.esv.freight.customer.module.pay.form.UnionPayOrderQueryForm;
import com.esv.freight.customer.module.pay.service.UnionpayOrderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 支付Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.pay.controller.PayController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/01 16:44
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/goodsowner/pay")
@Validated
public class PayController {

    private UnionpayOrderService unionpayOrderService;

    @Autowired
    public PayController(UnionpayOrderService unionpayOrderService) {
        this.unionpayOrderService = unionpayOrderService;
    }

    /**
     * description 创建支付订单
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author HuangChaobin
     * createTime 2020/06/02 9:13
     **/
    @PostMapping("/createPayOrder")
    public EResponse createPayOrder(@RequestBody @Validated CustomerPayOrderForm form) {
        String tn = unionpayOrderService.createCustomerPayOrder(form);

        JSONObject data = new JSONObject();
        data.put("tn", tn);

        return EResponse.ok(data);
    }

    /**
     * description 通过流水号查询订单状态
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author HuangChaobin
     * createTime 2020/06/03 13:34
     **/
    @PostMapping("/getOrderStatusByTn")
    public EResponse getOrderStatusByTn(@RequestBody @Validated UnionPayOrderQueryForm form) {
        if (StringUtils.isBlank(form.getTn())) {
            throw new EException(ECode.PARAM_ERROR.code(), "参数tn不能为空");
        }

        Integer orderStatus = unionpayOrderService.getOrderStatusByTn(form.getTn());
        JSONObject data = new JSONObject();
        data.put("orderStatus", orderStatus);

        return EResponse.ok(data);
    }

    /**
     * description 通过账单号查询订单状态
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author HuangChaobin
     * createTime 2020/06/03 13:34
     **/
    @PostMapping("/getOrderStatusByBillId")
    public EResponse getOrderStatusByBillId(@RequestBody @Validated UnionPayOrderQueryForm form) {
        if (StringUtils.isBlank(form.getBillId())) {
            throw new EException(ECode.PARAM_ERROR.code(), "参数orderId不能为空");
        }

        Integer orderStatus = unionpayOrderService.getOrderStatusByBillId(form.getBillId());
        JSONObject data = new JSONObject();
        data.put("orderStatus", orderStatus);

        return EResponse.ok(data);
    }

}
