package com.esv.freight.customer.module.goodsowner.form;

import com.esv.freight.customer.common.validator.groups.ValidatorList;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.form.AccountQueryForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 16:11
 * @version:1.0
 */
@Data
public class AccountQueryForm {

    /**
     * 货主类型：1-个人、2-企业
     */
    @Range(min = 1, max = 2, message = "参数ownerType不合法", groups = {ValidatorList.class})
    private Integer ownerType;
    /**
     * 货主编码
     */
    @Length( max = 20, message = "参数ownerNumber长度不合法", groups = {ValidatorList.class})
    private String ownerNumber;
    /**
     * 货主帐号审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    @Range(min = 0, max = 2, message = "参数auditStatus不合法", groups = {ValidatorList.class})
    private Integer auditStatus;
    /**
     * 帐号状态：1-正常、2-停用
     */
    @Range(min = 1, max = 2, message = "参数accountStatus不合法", groups = {ValidatorList.class})
    private String accountStatus;
    /**
     * （个人或企业联系人手机号）帐号
     */
    @Length(max = 11, message = "参数account长度不合法", groups = {ValidatorList.class})
    private String account;
    /**
     * 客户名称/客户简称/联系人
     */
    @Length(max = 50, message = "参数name长度不合法", groups = {ValidatorList.class})
    private String name;
    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
