package com.esv.freight.customer.module.goodsowner.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.vo.DeliveryAddressVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/21 19:39
 * @version:1.0
 */
@Data
public class DeliveryAddressVO {

    /**
     *
     */
    private Long id;
    /**
     * 地址编码
     */
    private String addressNumber;
    /**
     * 地址名称
     */
    private String addressName;
    /**
     * 省份代码
     */
    private String provinceCode;
    /**
     * 市代码
     */
    private String cityCode;
    /**
     * 区县代码
     */
    private String districtCode;
    /**
     * 详细地址
     */
    private String detailAddress;
    /**
     * 发货人
     */
    private String deliverer;
    /**
     * 发货人电话
     */
    private String delivererPhone;
    /**
     * 发货人座机
     */
    private String delivererTelephone;
    /**
     * 经度
     */
    private BigDecimal lon;
    /**
     * 纬度
     */
    private BigDecimal lat;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
