package com.esv.freight.customer.module.goodsowner.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.goodsowner.entity.ReceiveAddressEntity;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.ReceiveAddressForm;
import com.esv.freight.customer.module.goodsowner.vo.AddressBriefVO;
import com.esv.freight.customer.module.goodsowner.vo.ReceiveAddressVO;

import java.util.List;

/**
 * 货主收货地址表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-21 15:27:27
 */
public interface ReceiveAddressService extends IService<ReceiveAddressEntity> {

    /**
     * description 新增收货地址
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/21 15:59
     **/
    Long addAddress(ReceiveAddressForm form);

    /**
     * description 编辑收货地址
     * param [form]
     * return int
     * author Administrator
     * createTime 2020/04/21 17:56
     **/
    int editAddress(ReceiveAddressForm form);

    /**
     * description 删除收货地址
     * param [form]
     * return int
     * author Administrator
     * createTime 2020/04/21 19:23
     **/
    int deleteAddress(DeleteAddressForm form);

    /**
     * description 查看收货地址详情
     * param [form]
     * return com.esv.freight.customer.module.goodsowner.vo.Receive
     * author Administrator
     * createTime 2020/04/21 19:50
     **/
    ReceiveAddressVO getAddressDetail(ReceiveAddressForm form);

    /**
     * description 获取所有收货地址列表
     * param [form]
     * return java.util.List<com.esv.freight.customer.module.goodsowner.vo.AddressBriefVO>
     * author Administrator
     * createTime 2020/04/21 20:04
     **/
    List<AddressBriefVO> getAllAddress(ReceiveAddressForm form);

    /**
     * description 通过地址名称查询地址记录
     * param [ownerId, addressName]
     * return java.util.List<com.esv.freight.customer.module.goodsowner.entity.ReceiveAddressEntity>
     * author Administrator
     * createTime 2020/04/21 16:33
     **/
    List<ReceiveAddressEntity> getAddressByName(Long ownerId, String addressName);

    /**
     * description 分页查询地址列表
     * param [form]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/04/22 9:21
     **/
    PageResultVO selectAddressList(ReceiveAddressForm form);

}

