package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants;
import com.esv.freight.customer.module.goodsowner.form.AccountForm;
import com.esv.freight.customer.module.goodsowner.form.AccountInfoForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

import java.util.UUID;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.GoodsOwnerControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 14:37
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class GoodsOwnerControllerTest extends BaseTestController {

    @Test
    public void a1_createAccountByManager_personal_success_test() throws Exception {
        String url = "/goodsowner/account/add";

        // 构造数据
        AccountInfoForm form = new AccountInfoForm();
        form.setAccount("18524431581");
        form.setPassword("e28bec3e2feb42598b8cf1a1d3b11f4a");
        form.setOwnerType(GoodsOwnerConstants.OWNER_TYPE_PERSONAL);
        form.setContactor("黄朝斌");
        form.setIdCard("360721198712031234");
        form.setIdCardExpireDate("2030/12/31");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("双园路");
        form.setIdCardFrontUrl("http://127.0.0.1/001.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/002.jpg");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    @Test
    public void a1_createAccountByManager_company_success_test() throws Exception {
        String url = "/goodsowner/account/add";

        // 构造数据
        AccountInfoForm form = new AccountInfoForm();
        form.setAccount("18524431582");
        form.setPassword("e28bec3e2feb42598b8cf1a1d3b11f4a");
        form.setOwnerType(GoodsOwnerConstants.OWNER_TYPE_COMPANY);
        form.setContactor("黄朝斌");
        form.setIdCard("360721198712031234");
        form.setIdCardExpireDate("2030/12/31");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("双园路");
        form.setIdCardFrontUrl("http://127.0.0.1/001.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/002.jpg");
        form.setOwnerFullName("黄朝斌测试有限公司");
        form.setUniCreditCode("123456789");
        form.setCreditCopyUrl("http://127.0.0.1/003.jpg");
        form.setLegalPerson("黄卓越");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    @Test
    public void b1_updateAccountInfo_personal_success_test() throws Exception {
        String url = "/goodsowner/account/edit";

        // 构造数据
        AccountInfoForm form = new AccountInfoForm();
        form.setId(1L);
        form.setPassword(UUID.randomUUID().toString().replaceAll("-", ""));
        form.setOwnerType(GoodsOwnerConstants.OWNER_TYPE_PERSONAL);
        form.setContactor("黄朝斌01");
        form.setIdCard("11010119900307045X");
        form.setIdCardExpireDate("2030/12/31");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("双园路");
        form.setIdCardFrontUrl("http://127.0.0.1/001.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/002.jpg");
        form.setOwnerFullName("黄朝斌测试有限公司01");
        form.setUniCreditCode("123456789");
        form.setCreditCopyUrl("http://127.0.0.1/003.jpg");
        form.setLegalPerson("黄卓越");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    @Test
    public void b2_updateAccountInfo_company_success_test() throws Exception {
        String url = "/goodsowner/account/edit";

        // 构造数据
        AccountInfoForm form = new AccountInfoForm();
        form.setId(4L);
        form.setPassword(UUID.randomUUID().toString().replaceAll("-", ""));
        form.setOwnerType(GoodsOwnerConstants.OWNER_TYPE_COMPANY);
        form.setContactor("黄朝斌01");
        form.setIdCard("110101199003075031");
        form.setIdCardExpireDate("2030/12/31");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("双园路");
        form.setIdCardFrontUrl("http://127.0.0.1/001.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/002.jpg");
        form.setOwnerFullName("黄朝斌测试有限公司01");
        form.setOwnerBriefName("黄朝斌测试有限公司01");
        form.setUniCreditCode("1234567890");
        form.setCreditCopyUrl("http://127.0.0.1/003.jpg");
        form.setLegalPerson("黄卓越");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    @Test
    public void c1_blockAccount_success_test() throws Exception {
        String url = "/goodsowner/account/block";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    @Test
    public void c2_blockAccount_failure_test() throws Exception {
        String url = "/goodsowner/account/block";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    @Test
    public void d1_unblockAccount_success_test() throws Exception {
        String url = "/goodsowner/account/unblock";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    @Test
    public void d2_unblockAccount_failure_test() throws Exception {
        String url = "/goodsowner/account/unblock";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 审核不通过，备注为空
     **/
    @Test
    public void e1_auditAccount_failure_test() throws Exception {
        String url = "/goodsowner/account/audit";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        form.setAuditStatus(GoodsOwnerConstants.OWNER_AUDIT_STATUS_FAILURE);
        form.setRemark(null);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }

    /**
     * 审核不通过
     **/
    @Test
    public void e2_auditAccount_success_test() throws Exception {
        String url = "/goodsowner/account/audit";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        form.setAuditStatus(GoodsOwnerConstants.OWNER_AUDIT_STATUS_FAILURE);
        form.setRemark("测试");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 审核通过
     **/
    @Test
    public void e3_auditAccount_success_test() throws Exception {
        String url = "/goodsowner/account/audit";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        form.setAuditStatus(GoodsOwnerConstants.OWNER_AUDIT_STATUS_SUCCESS);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 查看帐号的审核历史
     **/
    @Test
    public void f1_getAccountAuditHistory_success_test() throws Exception {
        String url = "/goodsowner/account/audit/history";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 获取帐号详细信息：通过帐号id
     **/
    @Test
    public void g1_getAccountDetail_by_id_success_test() throws Exception {
        String url = "/goodsowner/account/detail";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 获取帐号详细信息：通过帐号
     **/
    @Test
    public void g2_getAccountDetail_by_account_success_test() throws Exception {
        String url = "/goodsowner/account/detail";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setAccount("18524431581");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 获取帐号详细信息：未设置参数
     **/
    @Test
    public void g3_getAccountDetail_no_param_failure_test() throws Exception {
        String url = "/goodsowner/account/detail";

        // 构造数据
        AccountForm form = new AccountForm();
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }

    /**
     * 获取帐号详细信息：无效的帐号ID
     **/
    @Test
    public void g4_getAccountDetail_wrong_id_failure_test() throws Exception {
        String url = "/goodsowner/account/detail";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setId(99999L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 获取帐号详细信息：无效的帐号
     **/
    @Test
    public void g5_getAccountDetail_wrong_account_failure_test() throws Exception {
        String url = "/goodsowner/account/detail";

        // 构造数据
        AccountForm form = new AccountForm();
        form.setAccount("12012345678");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }
}
