package com.esv.freight.customer.module.driver.form;

import com.esv.freight.customer.module.driver.validator.groups.ValidatorBind;
import com.esv.freight.customer.module.driver.validator.groups.ValidatorUnbind;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.form.DriverVehicleForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 19:54
 * @version:1.0
 */
@Data
public class DriverVehicleForm {

    /**
     * 司机ID
     */
    @NotNull(message = "参数driverId不能为空", groups = {ValidatorBind.class, ValidatorUnbind.class})
    private Long driverId;
    /**
     * 车辆ID
     */
    @NotNull(message = "参数vehicleId不能为空", groups = {ValidatorBind.class, ValidatorUnbind.class})
    private Long vehicleId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
