package com.esv.freight.customer.module.driver.form;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.form.DriverAuditForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 9:27
 * @version:1.0
 */
@Data
public class DriverAuditForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空")
    private Long id;

    /**
     * 审核状态：1-审核通过，2-审核不通过
     */
    @Range(min = 1, max = 2, message = "参数auditStatus不合法")
    @NotNull(message = "参数auditStatus不能为空")
    private Integer auditStatus;

    /**
     * 备注
     */
    @Length(max = 100, message = "参数remark长度不合法")
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
