package com.esv.freight.customer.module.carrier.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorList;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.form.CarrierQueryForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 19:23
 * @version:1.0
 */
@Data
public class CarrierQueryForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorDetail.class})
    private Long id;
    /**
     * 登录帐号，承运商联系人电话
     */
    @Length(max = 11, message = "参数account长度不合法", groups = {ValidatorList.class})
    private String account;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private String accountStatus;
    /**
     * 客户编码
     */
    @Length(max = 20, message = "参数carrierNumber长度不合法", groups = {ValidatorList.class})
    private String carrierNumber;
    /**
     * 统一社会信用代码
     */
    private String uniCreditCode;
    /**
     * 道路运输经营许可证号
     */
    private String roadLicenseNumber;
    /**
     * 承运商全称
     */
    private String carrierFullName;
    /**
     * 承运商名称
     */
    @Length(max = 50, message = "参数carrierName不合法", groups = {ValidatorList.class})
    private String carrierName;
    /**
     * 承运商类别：1-企业承运人、2-个体承运人
     */
    @Range(min = 1, max = 2, message = "参数carrierType不合法", groups = {ValidatorList.class})
    private Integer carrierType;
    /**
     * 承运商车辆类型（字典表）：1-自营车、2-外协车、3-其他
     */
    private Integer carrierVehicleType;
    /**
     * 联系人
     */
    private String contactor;

    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
