package com.esv.freight.customer.module.goodsowner.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.goodsowner.entity.DeliveryAddressEntity;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.DeliveryAddressForm;
import com.esv.freight.customer.module.goodsowner.vo.DeliveryAddressBriefVO;
import com.esv.freight.customer.module.goodsowner.vo.DeliveryAddressListVO;
import com.esv.freight.customer.module.goodsowner.vo.DeliveryAddressVO;

import java.util.List;
import java.util.Map;

/**
 * 货主发货地址表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-21 15:27:27
 */
public interface DeliveryAddressService extends IService<DeliveryAddressEntity> {

    /**
     * description 新增发货地址
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/21 15:59
     **/
    Long addAddress(DeliveryAddressForm form);

    /**
     * description 编辑发货地址
     * param [form]
     * return int
     * author Administrator
     * createTime 2020/04/21 17:56
     **/
    int editAddress(DeliveryAddressForm form);

    /**
     * description 删除发货地址
     * param [form]
     * return int
     * author Administrator
     * createTime 2020/04/21 19:23
     **/
    int deleteAddress(DeleteAddressForm form);

    /**
     * description 查看发货地址详情
     * param [form]
     * return com.esv.freight.customer.module.goodsowner.vo.DeliveryAddressVO
     * author Administrator
     * createTime 2020/04/21 19:50
     **/
    DeliveryAddressVO getAddressDetail(DeliveryAddressForm form);

    /**
     * description 获取所有发货地址列表
     * param [form]
     * return java.util.List<com.esv.freight.customer.module.goodsowner.vo.DeliveryAddressBriefVO>
     * author Administrator
     * createTime 2020/04/21 20:04
     **/
    List<DeliveryAddressBriefVO> getAllAddress(DeliveryAddressForm form);

    /**
     * description 通过地址名称查询地址记录
     * param [ownerId, addressName]
     * return java.util.List<com.esv.freight.customer.module.goodsowner.entity.DeliveryAddressEntity>
     * author Administrator
     * createTime 2020/04/21 16:33
     **/
    List<DeliveryAddressEntity> getAddressByName(Long ownerId, String addressName);

    /**
     * description 分页查询地址列表
     * param [form]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/04/22 9:21
     **/
    PageResultVO selectAddressList(DeliveryAddressForm form);

}

