package com.esv.freight.customer.config;

import com.esv.freight.customer.common.util.ReqUtils;
import com.esv.gateway.common.GatewayHeaders;
import feign.RequestInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import java.lang.reflect.Field;

/**
 * @description: Feign接口配置
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.config.FeignConfigure
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 18:00
 * @version:1.0
 */
@EnableFeignClients(basePackages = "com.esv.freight.customer.feign")
@Configuration
@Slf4j
public class FeignConfigure {

    @Value("${spring.application.name}")
    private String applicationName;

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public RequestInterceptor requestInterceptor() {
        RequestInterceptor requestInterceptor = ((requestTemplate -> {
            requestTemplate.header("trace_id", MDC.get("traceId"));
            requestTemplate.header("application_name", applicationName);

            Class cls = GatewayHeaders.class;
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; i++) {
                Field f = fields[i];
                f.setAccessible(true);
                String key;
                try {
                    key = String.valueOf(f.get(cls));
                    requestTemplate.header(key, ReqUtils.getRequestHeader(key));
                } catch (IllegalAccessException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }));
        return requestInterceptor;
    }
}
