package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorDelete;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.DeliveryAddressForm;
import com.esv.freight.customer.module.goodsowner.service.DeliveryAddressService;
import com.esv.freight.customer.module.goodsowner.service.ReceiveAddressService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 承运商发货地址Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.DeliveryAddressController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/21 15:40
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/goodsowner/delivery/address")
@Validated
public class DeliveryAddressController {

    private DeliveryAddressService deliveryAddressService;

    private ReceiveAddressService receiveAddressService;

    @Autowired
    public DeliveryAddressController(DeliveryAddressService deliveryAddressService, ReceiveAddressService receiveAddressService) {
        this.deliveryAddressService = deliveryAddressService;
        this.receiveAddressService = receiveAddressService;
    }

    /**
     * description 新增发货地址
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 16:56
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) DeliveryAddressForm form) throws EException {
        // 判断是否复制地址
        if (GoodsOwnerConstants.ADDRESS_COPY_YES.equals(form.getAddressCopy())) {

        }

        Long id = deliveryAddressService.addAddress(form);
        JSONObject data = new JSONObject();
        data.put("id", id);
        return EResponse.ok(data);
    }

    /**
     * description 编辑发货地址
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 18:56
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody @Validated(ValidatorUpdate.class) DeliveryAddressForm form) throws EException {
        deliveryAddressService.editAddress(form);
        return EResponse.ok();
    }

    /**
     * description 删除发货地址
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 19:27
     **/
    @PostMapping("/delete")
    public EResponse delete(@RequestBody @Validated(ValidatorDelete.class) DeleteAddressForm form) throws EException {
        int count = deliveryAddressService.deleteAddress(form);
        JSONObject data = new JSONObject();
        data.put("count", count);
        return EResponse.ok(data);
    }
}
