package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.RegularlyRouteForm;
import com.esv.freight.customer.module.goodsowner.form.RegularlyRouteListForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.DeliveryAddressControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/21 16:57
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class RegularlyRouteControllerTest extends BaseTestController {

    /**
     * 新增常跑线路
     **/
    @Test
    public void a1_add_success_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连英歌石植物园线路");
        form.setDeliveryId(7L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增常跑线路：名称重复
     **/
    @Test
    @Rollback
    public void a2_add_failure_repeat_name_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连线路");
        form.setDeliveryId(7L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 新增常跑线路：无效的货主ID
     **/
    @Test
    @Rollback
    public void a3_add_failure_repeat_name_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(99999L);
        form.setRouteName("沈阳-大连线路111");
        form.setDeliveryId(7L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 新增常跑线路：无效的发货地址ID
     **/
    @Test
    @Rollback
    public void a4_add_failure_wrong_delivery_id_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连线路111");
        form.setDeliveryId(99999L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 新增常跑线路：无效的收货地址ID
     **/
    @Test
    @Rollback
    public void a5_add_failure_wrong_receive_id_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连线路111");
        form.setDeliveryId(7L);
        form.setReceiveId(99999L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

    /**
     * 编辑常跑线路
     **/
    @Test
    public void b1_edit_success_test() throws Exception {
        String url = "/goodsowner/regularly/route/edit";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(1L);
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连华宇大厦线路");
        form.setDeliveryId(7L);
        form.setReceiveId(6L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 编辑常跑线路：无效的线路ID
     **/
    @Test
    @Rollback
    public void b2_edit_wrong_id_failure_test() throws Exception {
        String url = "/goodsowner/regularly/route/edit";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(99999L);
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连华宇大厦线路");
        form.setDeliveryId(7L);
        form.setReceiveId(6L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 编辑常跑线路：重复的常跑线路名称
     **/
    @Test
    @Rollback
    public void b3_edit_name_repeat_failure_test() throws Exception {
        String url = "/goodsowner/regularly/route/edit";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(1L);
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连英歌石植物园线路");
        form.setDeliveryId(7L);
        form.setReceiveId(6L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 编辑常跑线路：无效的货主ID
     **/
    @Test
    @Rollback
    public void b3_edit_wrong_owner_id_failure_test() throws Exception {
        String url = "/goodsowner/regularly/route/edit";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(1L);
        form.setOwnerId(99999L);
        form.setRouteName("沈阳-大连英歌石植物园线路111");
        form.setDeliveryId(7L);
        form.setReceiveId(6L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 编辑常跑线路：无效的发货地址ID
     **/
    @Test
    @Rollback
    public void b4_edit_wrong_delivery_id_failure_test() throws Exception {
        String url = "/goodsowner/regularly/route/edit";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(1L);
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连英歌石植物园线路111");
        form.setDeliveryId(99999L);
        form.setReceiveId(6L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

    /**
     * 编辑常跑线路：无效的收货地址ID
     **/
    @Test
    @Rollback
    public void b5_edit_wrong_receive_id_failure_test() throws Exception {
        String url = "/goodsowner/regularly/route/edit";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(1L);
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连英歌石植物园线路111");
        form.setDeliveryId(7L);
        form.setReceiveId(99999L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1005, result.getIntValue("code"));
    }

    /**
     * 删除常跑路线
     **/
    @Test
    @Rollback
    public void c1_delete_success_test() throws Exception {
        String url = "/goodsowner/regularly/route/delete";

        // 构造数据
        DeleteAddressForm form = new DeleteAddressForm();
        form.setId("1,2,3,4,5,6,7");
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("count"));
    }

    /**
     * 查询常跑路线详情
     **/
    @Test
    public void d1_detail_success_test() throws Exception {
        String url = "/goodsowner/regularly/route/detail";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 查询常跑路线详情：无效的常跑线路ID
     **/
    @Test
    public void d2_detail_wrong_id_failure_test() throws Exception {
        String url = "/goodsowner/regularly/route/detail";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setId(99999L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 查询货主所有常跑路线
     **/
    @Test
    public void e1_all_success_test() throws Exception {
        String url = "/goodsowner/regularly/route/all";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 查询常跑路线列表
     **/
    @Test
    public void f1_list_success_test() throws Exception {
        String url = "/goodsowner/regularly/route/list";

        // 构造数据
        RegularlyRouteListForm form = new RegularlyRouteListForm();
        form.setOwnerName("黄");
        form.setDeliveryAddressName("沈阳");
        form.setReceiveAddressName("植物园");
        form.setPageNum(1);
        form.setPageSize(10);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("records"));
    }

}
