package com.esv.freight.customer.module.driver;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.DriverConstants
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/28 15:00
 * @version:1.0
 */
public class DriverConstants {

    /**
     * 帐号状态：1-正常、2-停用
     **/
    public static final Integer ACCOUNT_STATUS_UNBLOCK = 1;
    public static final Integer ACCOUNT_STATUS_BLOCK = 2;

    /**
     * 帐号创建来源：1-平台创建、2-自行注册
     **/
    public static final Integer ACCOUNT_SOURCE_TYPE_PLATFORM = 1;
    public static final Integer ACCOUNT_SOURCE_TYPE_REGISTER = 2;

    /**
     * 帐号认证状态：1-未认证、2-已认证
     **/
    public static final Integer ACCOUNT_AUTHENTICATE_STATUS_NO = 1;
    public static final Integer ACCOUNT_AUTHENTICATE_STATUS_YES = 2;

    /**
     * 帐号审核状态：0-待审核、1-审核成功，2-审核失败
     **/
    public static final Integer ACCOUNT_AUDIT_STATUS_UNAUDITED = 0;
    public static final Integer ACCOUNT_AUDIT_STATUS_SUCCESS = 1;
    public static final Integer ACCOUNT_AUDIT_STATUS_FAILURE = 2;

    /**
     * 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
     **/
    public static final Integer ACCOUNT_DRIVING_VEHICLE_TYPE_1 = 1;
    public static final Integer ACCOUNT_DRIVING_VEHICLE_TYPE_2 = 2;
}
