package com.esv.freight.customer.module.goodsowner.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.module.goodsowner.entity.AccountEntity;
import com.esv.freight.customer.module.goodsowner.form.AccountInfoForm;

import java.util.List;

/**
 * 货主基础信息表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
public interface AccountService extends IService<AccountEntity> {

    /**
     * description 通过帐号查询帐号记录
     * param [account]
     * return com.esv.freight.customer.module.goodsowner.entity.AccountEntity
     * author Administrator
     * createTime 2020/04/17 15:46
     **/
    AccountEntity getAccountRecordByAccount(String account);

    /**
     * description 通过ID查询帐号记录
     * param [id]
     * return com.esv.freight.customer.module.goodsowner.entity.AccountEntity
     * author Administrator
     * createTime 2020/04/17 15:46
     **/
    AccountEntity getAccountRecordById(Long id);

    /**
     * description 通过管理平台创建帐号
     * param [form]
     * return Long
     * author Administrator
     * createTime 2020/04/17 16:05
     **/
    Long createAccountByManager(AccountInfoForm form);

    /**
     * description 更新帐号信息
     * param [form]
     * return void
     * author Administrator
     * createTime 2020/04/18 13:46
     **/
    void updateAccountInfo(AccountInfoForm form);

    /**
     * description 停用帐号
     * param [id]
     * return void
     * author Administrator
     * createTime 2020/04/18 14:59
     **/
    void blockAccount(Long id);

    /**
     * description 启用帐号
     * param [id]
     * return void
     * author Administrator
     * createTime 2020/04/18 14:59
     **/
    void unblockAccount(Long id);

}

