package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorDelete;
import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.RegularlyRouteForm;
import com.esv.freight.customer.module.goodsowner.service.RegularlyRouteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 长跑线路Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.RegularlyRouteController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/22 13:20
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/goodsowner/regularly/route")
@Validated
public class RegularlyRouteController {

    private RegularlyRouteService regularlyRouteService;

    @Autowired
    public RegularlyRouteController(RegularlyRouteService regularlyRouteService) {
        this.regularlyRouteService = regularlyRouteService;
    }

    /**
     * description 新增常跑线路
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/22 14:25
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) RegularlyRouteForm form) throws EException {
        Long id = regularlyRouteService.add(form);
        JSONObject data = new JSONObject();
        data.put("id", id);

        return EResponse.ok(data);
    }

    /**
     * description 编辑常跑路线
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/22 14:26
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody @Validated(ValidatorUpdate.class) RegularlyRouteForm form) throws EException {
        regularlyRouteService.edit(form);

        return EResponse.ok();
    }

    /**
     * description 删除常跑路线
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/22 14:58
     **/
    @PostMapping("/delete")
    public EResponse delete(@RequestBody @Validated(ValidatorDelete.class) DeleteAddressForm form) throws EException {
        int count = regularlyRouteService.delete(form);
        JSONObject data = new JSONObject();
        data.put("count", count);
        return EResponse.ok(data);
    }

    /**
     * description 查询常跑路线详情
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/22 15:29
     **/
    @PostMapping("/detail")
    public EResponse detail(@RequestBody @Validated(ValidatorDetail.class) RegularlyRouteForm form) throws EException {
        return EResponse.ok(regularlyRouteService.getRouteDetail(form));
    }
}
