package com.esv.freight.customer.common.component;

import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * @description: 帐号密码组件
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.component.PasswordComponent
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/20 10:40
 * @version:1.0
 */
@Component
public class PasswordComponent {

    /**
     * description 生成帐号密码盐
     * param []
     * return java.lang.String
     * author Administrator
     * createTime 2020/04/20 10:41
     **/
    public String generateAccountPwdSalt() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    /**
     * description 对（原始密码+盐）进行加密
     * param [initPwd, salt]
     * return java.lang.String
     * author Administrator
     * createTime 2020/04/20 10:44
     **/
    public String generatePwd4Salt(String initPwd, String salt) {
        return DigestUtils.md5Hex(initPwd + salt);
    }

    /**
     * description 校验密码
     * param [initPwd, salt, dbPwd]
     * return boolean
     * author Administrator
     * createTime 2020/04/20 10:47
     **/
    public boolean checkPwd4Salt(String initPwd, String salt, String dbPwd) {
        String digestPwd = this.generatePwd4Salt(initPwd, salt);
        if (digestPwd.equals(dbPwd)) {
            return true;
        } else {
            return false;
        }
    }

}
