package com.esv.freight.customer.module.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerForm;
import com.esv.freight.customer.module.contract.service.ContractOfflineGoodsOwnerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 线下文本合同-货主合同
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.controller.ContractOfflineGoodsOwnerController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/19 16:06
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/contract/offline/goodsowner")
@Validated
public class ContractOfflineGoodsOwnerController {

    private ContractOfflineGoodsOwnerService contractOfflineGoodsOwnerService;

    @Autowired
    public ContractOfflineGoodsOwnerController(ContractOfflineGoodsOwnerService contractOfflineGoodsOwnerService) {
        this.contractOfflineGoodsOwnerService = contractOfflineGoodsOwnerService;
    }

    /**
     * description 新增合同
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/19 16:10
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) ContractOfflineGoodsOwnerForm form) throws EException {
        Long id = contractOfflineGoodsOwnerService.addOfflineContract(form);
        JSONObject data = new JSONObject();
        data.put("id", id);
        return EResponse.ok(data);
    }
}
