package com.esv.freight.customer.module.contract.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 线下文本合同（承运商）
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-19 14:05:38
 */
@Data
@TableName("contract_offline_carrier")
public class ContractOfflineCarrierEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 承运商帐号ID
	 */
	private Long carrierId;
	/**
	 * 合同编号
	 */
	private String contractNumber;
	/**
	 * 合同名称
	 */
	private String contractName;
	/**
	 * 合同类型：1-主合同、2-补充合同、3-临时合同
	 */
	private Integer contractType;
	/**
	 * 合同签订日期
	 */
	private Date signDate;
	/**
	 * 合同起始日期
	 */
	private Date startDate;
	/**
	 * 合同截止日期
	 */
	private Date endDate;
	/**
	 * 合同文件URL
	 */
	private String fileUrl;
	/**
	 * 删除标识：0-未删除，1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
