package com.esv.freight.customer.module.servlet;

import com.esv.freight.customer.common.util.ResUtils;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.servlet.AppFrontRcvServlet
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/02 18:57
 * @version:1.0
 */
@Slf4j
public class AppFrontRcvServlet extends HttpServlet {

    /**
     * description 前端APP支付成功通过银联支付控件调用（frontUrl）
     * param [req, resp]
     * return void
     * author HuangChaobin
     * createTime 2020/06/02 19:28
     **/
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) {
        Map<String, String> reqParam = this.getAllRequestParam(req);
        log.info(reqParam.toString());

        //返回给银联服务器http 200  状态码
        ResUtils.response(resp, HttpServletResponse.SC_OK, "text/plain;charset=utf-8", "ok");
    }

    /**
     * 获取请求参数中所有的信息
     *
     * @param request
     * @return
     */
    private Map<String, String> getAllRequestParam(final HttpServletRequest request) {
        Map<String, String> res = new HashMap<>(32);
        Enumeration<?> temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String) temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                // 在报文上送时，如果字段的值为空，则不上送<下面的处理为在获取所有参数数据时，判断若值为空，则删除这个字段>
                if (null == res.get(en) || "".equals(res.get(en))) {
                    res.remove(en);
                }
            }
        }
        return res;
    }
}
