package com.esv.freight.customer.module.contract.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 线上电子合同平台数据表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-21 15:55:34
 */
@Data
@TableName("contract_online_platform_data")
public class ContractOnlinePlatformDataEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 公章文件ID
	 */
	private String sealFileId;
	/**
	 * 公章文件URL
	 */
	private String sealFileUrl;
	/**
	 * 平台名称
	 */
	private String platformName;
	/**
	 * 平台组织机构代码
	 */
	private String platformId;
	/**
	 * 数据名称
	 */
	private String dataName;
	/**
	 * 是否使用：1使用中，2-未使用
	 */
	private Integer used;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
