package com.esv.freight.customer.module.goodsowner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.common.component.ErrorMessageComponent;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.module.goodsowner.dao.InfoDao;
import com.esv.freight.customer.module.goodsowner.entity.InfoEntity;
import com.esv.freight.customer.module.goodsowner.form.AccountScoreForm;
import com.esv.freight.customer.module.goodsowner.service.GoodsOwnerInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service("goodsOwnerInfoService")
public class GoodsOwnerInfoServiceImpl extends ServiceImpl<InfoDao, InfoEntity> implements GoodsOwnerInfoService {

    private ErrorMessageComponent errorMessageComponent;

    @Autowired
    public GoodsOwnerInfoServiceImpl(ErrorMessageComponent errorMessageComponent) {
        this.errorMessageComponent = errorMessageComponent;
    }

    @Override
    public Integer updateOverallScore(AccountScoreForm form) {
        InfoEntity dbEntity = this.baseMapper.selectOne(new LambdaQueryWrapper<InfoEntity>().eq(InfoEntity::getAccountId, form.getId()));
        if (null == dbEntity) {
            throw new EException(1001, errorMessageComponent.getGoodsOwnerScoreOverallUpdate1001());
        }

        InfoEntity infoEntity = new InfoEntity();
        infoEntity.setId(dbEntity.getId());
        infoEntity.setOverallScore(form.getScore());
        return this.baseMapper.updateById(infoEntity);
    }
}