package com.esv.freight.customer.module.contract.controller;

import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.common.validator.groups.ValidatorList;
import com.esv.freight.customer.module.contract.form.*;
import com.esv.freight.customer.module.contract.service.ContractOnlineRecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.controller.ContractOnlineRecordController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 11:08
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/contract/online")
@Validated
public class ContractOnlineRecordController {
    
    private ContractOnlineRecordService contractOnlineRecordService;

    @Autowired
    public ContractOnlineRecordController(ContractOnlineRecordService contractOnlineRecordService) {
        this.contractOnlineRecordService = contractOnlineRecordService;
    }

    /**
     * description 货主与平台的电子合同-货主签订
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/22 11:10
     **/
    @PostMapping("/goodsowner/sign")
    public EResponse goodsOwnerSign(@RequestBody @Validated ContractOnlineRecordSignGoodsOwnerForm form) throws EException {
        return EResponse.ok(contractOnlineRecordService.goodsOwnerSign(form));
    }

    /**
     * description 司机与平台的电子合同-司机签订
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/26 15:19
     **/
    @PostMapping("/driver/sign")
    public EResponse driverSign(@RequestBody @Validated ContractOnlineRecordSignDriverForm form) throws EException {
        return EResponse.ok(contractOnlineRecordService.driverSign(form));
    }

    /**
     * description 电子合同-平台签订
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/25 11:25
     **/
    @PostMapping("/platform/sign")
    public EResponse platformSign(@RequestBody @Validated(ValidatorDetail.class) ContractOnlineRecordForm form) throws EException {
        contractOnlineRecordService.platformSign(form.getContractNumber());
        return EResponse.ok();
    }

    /**
     * description 根据合同编号获取合同信息
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/22 17:20
     **/
    @PostMapping("/getContractByNumber")
    public EResponse getContractByNumber(@RequestBody @Validated(ValidatorDetail.class) ContractOnlineRecordForm form) throws EException {
        return EResponse.ok(contractOnlineRecordService.getContractInfoByNumber(form.getContractNumber()));
    }

    /**
     * description 分页查询电子合同列表
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/28 10:06
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody @Validated(ValidatorList.class) ContractOnlineRecordQueryForm form) throws EException {
        return EResponse.ok(contractOnlineRecordService.getContractList(form));
    }

    @PostMapping("/blockChain")
    public EResponse blockChain(@RequestBody @Validated BlockChainForm form) throws EException {
        contractOnlineRecordService.blockChain(form);
        return EResponse.ok();
    }

    @PostMapping("/getBlockChain")
    public EResponse getBlockChain(@RequestBody @Validated BlockChainForm form) throws EException {
        return EResponse.ok(contractOnlineRecordService.getBlockChain(form));
    }
}
