package com.esv.freight.customer.module.vehicle.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.module.vehicle.dto.VehicleDetailDto;
import com.esv.freight.customer.module.vehicle.entity.VehicleEntity;
import com.esv.freight.customer.module.vehicle.form.VehicleAuditForm;
import com.esv.freight.customer.module.vehicle.form.VehicleInfoForm;

/**
 * 车辆表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-26 11:21:07
 */
public interface VehicleService extends IService<VehicleEntity> {

    /**
     * description 新增车辆
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/26 14:50
     **/
    Long insertVehicle(VehicleInfoForm form);

    /**
     * description 更新车辆信息
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/27 9:23
     **/
    Integer updateVehicle(VehicleInfoForm form);

    /**
     * description 获取车辆详情
     * param [id]
     * return com.esv.freight.customer.module.vehicle.dto.VehicleDetailDto
     * author Administrator
     * createTime 2020/04/27 13:56
     **/
    VehicleDetailDto getVehicleDetail(Long id);

    /**
     * description 审核车辆
     * param [form]
     * return void
     * author Administrator
     * createTime 2020/04/27 15:38
     **/
    void auditVehicle(VehicleAuditForm form);

    /**
     * description 车辆是否存在
     * param [id]
     * return java.lang.Boolean
     * author Administrator
     * createTime 2020/04/27 16:29
     **/
    Boolean vehicleExits(Long id);

}

