package com.esv.freight.customer.common.util;

import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.Base64;
import java.util.Hashtable;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.LdapUtilsTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/17 17:50
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class LdapUtilsTest {

    @Test
    public void ldap_login_test() {
        String pwd = "12342234";
        log.info(pwd);
        String pwdBase64 = Base64.getEncoder().encodeToString(pwd.getBytes());
        log.info(pwdBase64);
        pwd = new String(Base64.getDecoder().decode(pwdBase64));
        log.info(pwd);

        try {
            String bindUserDN = "cn=huangcb,cn=esvsy,dc=esvtek,dc=com";  // 用户 DN
            String bindPassword = "12342234"; // 用户密码
            String url = "ldap://192.168.31.249:389/";  // ldap服务器IP
            Hashtable<String, String> env = new Hashtable<>();
            env.put(javax.naming.Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
            env.put(javax.naming.Context.PROVIDER_URL, url);
            env.put(javax.naming.Context.SECURITY_AUTHENTICATION, "simple");
            env.put(javax.naming.Context.SECURITY_PRINCIPAL, bindUserDN);
            env.put(javax.naming.Context.SECURITY_CREDENTIALS, bindPassword);
            javax.naming.directory.DirContext ctx = new javax.naming.directory.InitialDirContext(env);
            System.out.println("身份验证成功!");
        } catch (Exception e) {
            System.out.println("身份验证失败!");
            e.printStackTrace();
        }
    }

}
