package com.esv.freight.customer.config;

import com.esv.freight.customer.module.servlet.AppFrontRcvServlet;
import com.esv.freight.customer.module.servlet.UnionpayBackRcvServlet;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description: 注册Servlet
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.config.ServletConfig
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/02 18:59
 * @version:1.0
 */
@Configuration
public class ServletConfig {

    @Bean
    public AppFrontRcvServlet getAppFrontRcvServlet() {
        return new AppFrontRcvServlet();
    }

    @Bean
    public ServletRegistrationBean appFrontRcvServletRegistrationBean() {
        ServletRegistrationBean registrationBean = new ServletRegistrationBean(getAppFrontRcvServlet(), "/pay/frontRcvResponse");
        return registrationBean;
    }

    @Bean
    public UnionpayBackRcvServlet getUnionpayBackRcvServlet() {
        return new UnionpayBackRcvServlet();
    }

    @Bean
    public ServletRegistrationBean unionpayBackRcvServletRegistrationBean() {
        ServletRegistrationBean registrationBean = new ServletRegistrationBean(getUnionpayBackRcvServlet(), "/pay/backRcvResponse");
        return registrationBean;
    }
}
