package com.esv.freight.customer.module.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.module.contract.ContractConstants;
import com.esv.freight.customer.module.contract.dao.ContractOnlinePlatformDataDao;
import com.esv.freight.customer.module.contract.entity.ContractOnlinePlatformDataEntity;
import com.esv.freight.customer.module.contract.service.ContractOnlinePlatformDataService;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.service.impl.ContractOnlinePlatformDataServiceImpl
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/25 10:51
 * @version:1.0
 */
@Service("contractOnlinePlatformDataService")
public class ContractOnlinePlatformDataServiceImpl  extends ServiceImpl<ContractOnlinePlatformDataDao, ContractOnlinePlatformDataEntity> implements ContractOnlinePlatformDataService {

    @Override
    public ContractOnlinePlatformDataEntity getUsedData() {
        return this.baseMapper.selectOne(new LambdaQueryWrapper<ContractOnlinePlatformDataEntity>()
                .eq(ContractOnlinePlatformDataEntity::getUsed, ContractConstants.CONTRACT_PLATFORM_DATA_USED_YES));
    }
}
