package com.esv.freight.customer.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.feign.FeignBaseService
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 17:56
 * @version:1.0
 */
@FeignClient(value = "freight-base-service")
public interface FeignBaseService {

    /**
     * description 连通性测试
     * param []
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/22 14:05
     **/
    @GetMapping(value = "/base/test/ping")
    JSONObject pingTest();

    /**
     * description 生成编号
     * param [bodyJson]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/06 14:36
     **/
    @PostMapping(value = "/base/batchId/generate")
    JSONObject getBatchId(JSONObject bodyJson);

    /**
     * description 获取全国省市行政区划(键值对)
     * param [bodyJson]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/08 15:54
     **/
    @PostMapping(value = "/base/geo/city/getAllRegionMap")
    JSONObject getAllRegionMap(JSONObject bodyJson);

    /**
     * description 获取图片验证码
     * param [bodyJson]
     * return com.alibaba.fastjson.JSONObject
     * author HuangChaobin
     * createTime 2020/06/19 13:10
     **/
    @PostMapping(value = "/base/captcha/get")
    JSONObject getDefaultCaptcha(JSONObject bodyJson);

}
