package com.esv.freight.customer.common.util;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.PictureRenderData;
import com.esv.freight.customer.module.contract.pojo.ContractOnlineGoodsOwnerPojo;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.WordTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/21 10:49
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class WordTest {

    @Test
    public void simple_test() throws Exception {
        String sourcePath = "D:\\test\\线上合同-货主.docx";
        String targetPath = "D:\\test\\线上合同-货主-合成.docx";

        Map<String, Object> dataMap = new HashMap<>();
        dataMap.put("contactNumber", System.currentTimeMillis());
        dataMap.put("goodsOwnerName", "黄朝斌测试有限公司01");
        dataMap.put("goodsOwnerId", "1234567890");
        dataMap.put("platformName", "英思唯网络货运平台");
        dataMap.put("platformId", "123422345678");
        dataMap.put("goodsName", "test");
        dataMap.put("goodsTotal", "test");
        dataMap.put("goodsUnit", "test");
        dataMap.put("goodsUnitPrice", "test");
        dataMap.put("goodsTotalPrice", "test");
        dataMap.put("deliverAddress", "test");
        dataMap.put("receiveAddress", "test");
        dataMap.put("deliverTime", "test");
        dataMap.put("receiveTime", "test");
        dataMap.put("freightCharge", "test");
        dataMap.put("depositCharge", "test");
//        dataMap.put("signTime", DateUtils.getSysdateStr());
        dataMap.put("signTime", "{{signTime}}");

        dataMap.put("goodsOnwerSignImg", new PictureRenderData(150, 60, "D:\\test\\何锋.jpg"));
        dataMap.put("platformFreightSealImg", new PictureRenderData(203, 220, "D:\\test\\公章.jpg"));

        XWPFTemplate template = XWPFTemplate.compile(sourcePath);
        template.render(dataMap);
        FileOutputStream out = new FileOutputStream(targetPath);
        template.write(out);
        out.flush();
        out.close();
        template.close();
    }

    @Test
    public void pojo_test() throws Exception {
        String sourcePath = "D:\\test\\线上合同-货主.docx";
        String targetPath = "D:\\test\\线上合同-货主-合成.docx";

        ContractOnlineGoodsOwnerPojo pojo = new ContractOnlineGoodsOwnerPojo();
        pojo.setContactNumber(String.valueOf(System.currentTimeMillis()));
        pojo.setGoodsOwnerName("黄朝斌测试有限公司01");
        pojo.setGoodsOwnerId("1234567890");
        pojo.setPlatformName("英思唯网络货运平台");
        pojo.setPlatformId("123422345678");
        pojo.setGoodsName("test");
        pojo.setGoodsTotal("test");
        pojo.setGoodsUnit("test");
        pojo.setGoodsUnitPrice("test");
        pojo.setGoodsTotalPrice("test");
        pojo.setDeliverAddress("test");
        pojo.setDeliverTime("test");
        pojo.setReceiveAddress("test");
        pojo.setReceiveTime("test");
        pojo.setFreightCharge("test");
        pojo.setDepositCharge("test");
        pojo.setEffectiveTime("{{effectiveTime}}");
        pojo.setGoodsOwnerSignImg(new PictureRenderData(150, 60, "D:\\test\\何锋.jpg"));
        pojo.setPlatformFreightSealImg("{{@platformFreightSealImg}}");

        XWPFTemplate template = XWPFTemplate.compile(sourcePath);
        template.render(pojo);
        FileOutputStream out = new FileOutputStream(targetPath);
        template.write(out);
        out.flush();
        out.close();
        template.close();
    }
}
