package com.esv.freight.customer.module.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.common.component.ErrorMessageComponent;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.util.DateUtils;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.contract.dao.ContractOfflineGoodsOwnerDao;
import com.esv.freight.customer.module.contract.dto.ContractOfflineGoodsOwnerDto;
import com.esv.freight.customer.module.contract.entity.ContractOfflineGoodsOwnerEntity;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerQueryForm;
import com.esv.freight.customer.module.contract.service.ContractOfflineGoodsOwnerService;
import com.esv.freight.customer.module.contract.vo.ContractOfflineGoodsOwnerDetailVO;
import com.esv.freight.customer.module.contract.vo.ContractOfflineGoodsOwnerVO;
import com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants;
import com.esv.freight.customer.module.goodsowner.entity.GoodsOwnerAccountEntity;
import com.esv.freight.customer.module.goodsowner.service.GoodsOwnerAccountService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


@Service("contractOfflineGoodsOwnerService")
public class ContractOfflineGoodsOwnerServiceImpl extends ServiceImpl<ContractOfflineGoodsOwnerDao, ContractOfflineGoodsOwnerEntity> implements ContractOfflineGoodsOwnerService {

    private ErrorMessageComponent errorMessageComponent;

    private GoodsOwnerAccountService goodsOwnerAccountService;

    @Autowired
    public ContractOfflineGoodsOwnerServiceImpl(ErrorMessageComponent errorMessageComponent, GoodsOwnerAccountService goodsOwnerAccountService) {
        this.errorMessageComponent = errorMessageComponent;
        this.goodsOwnerAccountService = goodsOwnerAccountService;
    }

    @Override
    public Long addOfflineContract(ContractOfflineGoodsOwnerForm form) {
        // 1:校验
        GoodsOwnerAccountEntity goodsOwnerAccountEntity = goodsOwnerAccountService.getAccountRecordById(form.getGoodsOwnerId());
        if (null == goodsOwnerAccountEntity) {
            throw new EException(1001, errorMessageComponent.getContractOfflineGoodsOwnerAdd1001());
        }
        int count = this.baseMapper.selectCount(new LambdaQueryWrapper<ContractOfflineGoodsOwnerEntity>()
                .eq(ContractOfflineGoodsOwnerEntity::getGoodsOwnerId, form.getGoodsOwnerId())
                .eq(ContractOfflineGoodsOwnerEntity::getContractNumber, form.getContractNumber()));
        if (0 < count) {
            throw new EException(1002, errorMessageComponent.getContractOfflineGoodsOwnerAdd1002());
        }

        // 2:新增记录
        ContractOfflineGoodsOwnerEntity contractOfflineGoodsOwnerEntity = new ContractOfflineGoodsOwnerEntity();
        BeanUtils.copyProperties(form, contractOfflineGoodsOwnerEntity);
        contractOfflineGoodsOwnerEntity.setSignDate(DateUtils.parse(form.getSignDate(), DateUtils.DATE_FORMAT3));
        contractOfflineGoodsOwnerEntity.setStartDate(DateUtils.parse(form.getStartDate(), DateUtils.DATE_FORMAT3));
        contractOfflineGoodsOwnerEntity.setEndDate(DateUtils.parse(form.getEndDate(), DateUtils.DATE_FORMAT3));
        this.baseMapper.insert(contractOfflineGoodsOwnerEntity);

        return contractOfflineGoodsOwnerEntity.getId();
    }

    @Override
    public Integer editOfflineContract(ContractOfflineGoodsOwnerForm form) {
        // 1:校验
        ContractOfflineGoodsOwnerEntity dbEntity = this.baseMapper.selectById(form.getId());
        if (null == dbEntity) {
            throw new EException(1001, errorMessageComponent.getContractOfflineGoodsOwnerEdit1001());
        }
        int count = this.baseMapper.selectCount(new LambdaQueryWrapper<ContractOfflineGoodsOwnerEntity>()
                .ne(ContractOfflineGoodsOwnerEntity::getId, form.getId())
                .eq(ContractOfflineGoodsOwnerEntity::getGoodsOwnerId, dbEntity.getGoodsOwnerId())
                .eq(ContractOfflineGoodsOwnerEntity::getContractNumber, form.getContractNumber()));
        if (0 < count) {
            throw new EException(1002, errorMessageComponent.getContractOfflineGoodsOwnerAdd1002());
        }

        // 2:更新记录
        ContractOfflineGoodsOwnerEntity contractOfflineGoodsOwnerEntity = new ContractOfflineGoodsOwnerEntity();
        BeanUtils.copyProperties(form, contractOfflineGoodsOwnerEntity);
        contractOfflineGoodsOwnerEntity.setGoodsOwnerId(null);
        contractOfflineGoodsOwnerEntity.setSignDate(DateUtils.parse(form.getSignDate(), DateUtils.DATE_FORMAT3));
        contractOfflineGoodsOwnerEntity.setStartDate(DateUtils.parse(form.getStartDate(), DateUtils.DATE_FORMAT3));
        contractOfflineGoodsOwnerEntity.setEndDate(DateUtils.parse(form.getEndDate(), DateUtils.DATE_FORMAT3));

        return this.baseMapper.updateById(contractOfflineGoodsOwnerEntity);
    }

    @Override
    public Integer deleteOfflineContract(ContractOfflineGoodsOwnerForm form) {
        ContractOfflineGoodsOwnerEntity dbEntity = this.baseMapper.selectById(form.getId());
        if (null == dbEntity) {
            throw new EException(1001, errorMessageComponent.getContractOfflineGoodsOwnerDelete1001());
        }

        return this.baseMapper.deleteById(form.getId());
    }

    @Override
    public ContractOfflineGoodsOwnerDetailVO getOfflineContractDetail(Long id) {
        ContractOfflineGoodsOwnerEntity dbEntity = this.baseMapper.selectById(id);
        if (null == dbEntity) {
            throw new EException(1001, errorMessageComponent.getContractOfflineGoodsOwnerDetail1001());
        }

        ContractOfflineGoodsOwnerDto dto = this.baseMapper.selectContractDetail(id);
        ContractOfflineGoodsOwnerDetailVO vo = new ContractOfflineGoodsOwnerDetailVO();
        BeanUtils.copyProperties(dto, vo);
        if (GoodsOwnerConstants.OWNER_TYPE_COMPANY.equals(dto.getOwnerType())) {
            vo.setGoodsOwnerName(dto.getOwnerFullName());
        } else {
            vo.setGoodsOwnerName(dto.getContactor());
        }
        vo.setSignDate(DateUtils.format(dto.getSignDate(), DateUtils.DATE_FORMAT3));
        vo.setStartDate(DateUtils.format(dto.getStartDate(), DateUtils.DATE_FORMAT3));
        vo.setEndDate(DateUtils.format(dto.getEndDate(), DateUtils.DATE_FORMAT3));

        return vo;
    }

    @Override
    public PageResultVO selectContractList(ContractOfflineGoodsOwnerQueryForm queryForm) {
        IPage<ContractOfflineGoodsOwnerDto> page = new Page<>(queryForm.getPageNum(), queryForm.getPageSize());
        this.baseMapper.selectContractList(page, queryForm);

        // 数据转换
        List<ContractOfflineGoodsOwnerDto> dtoList = page.getRecords();
        List<ContractOfflineGoodsOwnerVO> targetRecordList = new ArrayList<>();
        for (ContractOfflineGoodsOwnerDto dto : dtoList) {
            ContractOfflineGoodsOwnerVO vo = new ContractOfflineGoodsOwnerVO();
            BeanUtils.copyProperties(dto, vo);
            if (GoodsOwnerConstants.OWNER_TYPE_COMPANY.equals(dto.getOwnerType())) {
                vo.setGoodsOwnerName(dto.getOwnerFullName());
            } else {
                vo.setGoodsOwnerName(dto.getContactor());
            }
            vo.setSignDate(dto.getSignDate().getTime());
            vo.setStartDate(dto.getStartDate().getTime());
            vo.setEndDate(dto.getEndDate().getTime());
            vo.setCreateTime(dto.getCreateTime().getTime());
            targetRecordList.add(vo);
        }

        return new PageResultVO(page, targetRecordList);
    }
}