package com.esv.freight.customer.module.contract.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.contract.entity.ContractOfflineCarrierEntity;
import com.esv.freight.customer.module.contract.form.ContractOfflineCarrierForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineCarrierQueryForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerQueryForm;
import com.esv.freight.customer.module.contract.vo.ContractOfflineCarrierDetailVO;

/**
 * 线下文本合同（承运商）
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-19 14:05:38
 */
public interface ContractOfflineCarrierService extends IService<ContractOfflineCarrierEntity> {

    /**
     * description 新增线下文本合同（承运商）
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/19 14:49
     **/
    Long addOfflineContract(ContractOfflineCarrierForm form);

    /**
     * description 编辑线下文本合同（承运商）
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/19 19:34
     **/
    Integer editOfflineContract(ContractOfflineCarrierForm form);

    /**
     * description 删除线下文本合同（承运商）
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/20 9:24
     **/
    Integer deleteOfflineContract(ContractOfflineCarrierForm form);

    /**
     * description 获取线下文本合同（承运商）详情
     * param [id]
     * return com.esv.freight.customer.module.contract.vo.ContractOfflineCarrierDetailVO
     * author Administrator
     * createTime 2020/05/27 20:00
     **/
    ContractOfflineCarrierDetailVO getContractDetail(Long id);

    /**
     * description 分页查询合同列表
     * param [queryForm]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/05/20 11:18
     **/
    PageResultVO selectContractList(ContractOfflineCarrierQueryForm queryForm);

}

