package com.esv.freight.customer.module.contract.pojo;

import lombok.Data;

/**
 * @description: 货主与平台签订合同的模板内容项
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.pojo.ContractOnlineGoodsOwnerPojo
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 10:05
 * @version:1.0
 */
@Data
public class ContractOnlineGoodsOwnerPojo {

    /**
     * 合同编号
     */
    private String contactNumber;
    /**
     * 托运方
     */
    private String goodsOwnerName;
    /**
     * 托运方身份证号码/组织机构代码
     */
    private String goodsOwnerId;
    /**
     * 承运方
     */
    private String platformName;
    /**
     * 承运方组织机构代码
     */
    private String platformId;
    /**
     * 货物名称
     */
    private String goodsName;
    /**
     * 货物总量
     */
    private String goodsTotal;
    /**
     * 货物单位
     */
    private String goodsUnit;
    /**
     * 货物单价
     */
    private String goodsUnitPrice;
    /**
     * 货物总价
     */
    private String goodsTotalPrice;
    /**
     * 发货地址
     */
    private String deliverAddress;
    /**
     * 收货地址
     */
    private String receiveAddress;
    /**
     * 发货时间
     */
    private String deliverTime;
    /**
     * 交货时间
     */
    private String receiveTime;
    /**
     * 本次运输运费
     */
    private String freightCharge;
    /**
     * 预付定金
     */
    private String depositCharge;
    /**
     * 托运方签字
     */
    private Object goodsOwnerSignImg;
    /**
     * 承运方签字
     */
    private Object platformFreightSealImg;
    /**
     * 生效时间
     */
    private String effectiveTime;

}
