package com.esv.freight.customer.module.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.module.contract.form.ContractOnlineTemplateForm;
import com.esv.freight.customer.module.contract.service.ContractOnlineTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 电子合同模板Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.controller.ContractOnlineTemplateController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/21 17:07
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/contract/online/template")
@Validated
public class ContractOnlineTemplateController {
    
    private ContractOnlineTemplateService contractOnlineTemplateService;

    @Autowired
    public ContractOnlineTemplateController(ContractOnlineTemplateService contractOnlineTemplateService) {
        this.contractOnlineTemplateService = contractOnlineTemplateService;
    }

    /**
     * description 增加电子合同模板
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/21 17:11
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) ContractOnlineTemplateForm form) throws EException {
        Long id = contractOnlineTemplateService.addTemplate(form);
        JSONObject data = new JSONObject();
        data.put("id", id);
        return EResponse.ok(data);
    }
    
}
