package com.esv.freight.customer.common.util;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.ECode;
import com.esv.gateway.common.GatewayHeaders;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * @description：Http请求工具类
 * @author：hcbmailbox@163.com
 * @date：2019/12/25
 */
@Slf4j
public class ReqUtils {

    public static String getRequestHeader(String headerKey) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        return request.getHeader(headerKey);
    }

    /**
     * description 获取当前请求的用户ID
     * param []
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/28 14:08
     **/
    public static Long getRequestUserId() {
        String userId = getRequestHeader(GatewayHeaders.USER_ID);
        if (StringUtils.isNotBlank(userId)) {
            return Long.parseLong(userId);
        } else {
            return null;
        }
    }

    /**
     * description 获取当前请求的租户ID
     * param []
     * return java.lang.Long
     * author Administrator
     * createTime 2020/05/25 13:55
     **/
    public static Long getRequestTenantId() {
        String userId = getRequestHeader(GatewayHeaders.TENANT_ID);
        if (StringUtils.isNotBlank(userId)) {
            return Long.parseLong(userId);
        } else {
            return null;
        }
    }

    /**
     * description 获取当前请求的用户帐号
     * param []
     * return java.lang.String
     * author Administrator
     * createTime 2020/04/28 14:12
     **/
    public static String getRequestUserAccount() {
        return getRequestHeader(GatewayHeaders.USER_ACCOUNT);
    }

    /**
     * 获得Http客户端的ip
     * @param req
     * @return
     */
    public static String getHttpClientIp(HttpServletRequest req){
        String ip = req.getHeader("x-forwarded-for");
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = req.getHeader("Proxy-Client-IP");
        }
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = req.getHeader("WL-Proxy-Client-IP");
        }
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = req.getRemoteAddr();
        }
        return ip;
    }

    /**
     * description 校验参数不能为空：key存在、value存在且不为空字符串
     * param [reqJson, params]
     * return void
     * author Administrator
     * createTime 2020/04/17 17:23
     **/
    public static void checkParamsNotBlank(JSONObject reqJson, String[] params) throws EException {
        for (int i = 0; i < params.length; i++) {
            if (StringUtils.isBlank(reqJson.getString(params[i]))) {
                throw new EException(ECode.PARAM_ERROR.code(), "参数"+params[i]+"不能为空");
            }
        }
    }

}
