package com.esv.freight.customer.module.contract.form;

import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.form.ContractOnlineTemplateForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/21 16:48
 * @version:1.0
 */
@Data
public class ContractOnlineTemplateForm {

    /**
     * 合同类型：1-货主与平台合同、2-司机与平台合同
     */
    @Range(min = 1, max = 2, message = "参数contractType不合法", groups = {ValidatorInsert.class})
    @NotNull(message = "参数contractType不能为空", groups = {ValidatorInsert.class})
    private Integer contractType;
    /**
     * 合同模板文件ID
     */
    @Length(max = 64, message = "参数templateFileId长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数templateFileId不能为空", groups = {ValidatorInsert.class})
    private String templateFileId;
    /**
     * 合同模板文件URL
     */
    @Length(max = 200, message = "参数templateFileUrl长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数templateFileUrl不能为空", groups = {ValidatorInsert.class})
    private String templateFileUrl;
    /**
     * 合同模板名称
     */
    @Length(max = 50, message = "参数templateName长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数templateName不能为空", groups = {ValidatorInsert.class})
    private String templateName;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
