package com.esv.freight.customer.module.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.contract.form.ContractOnlineRecordForm;
import com.esv.freight.customer.module.contract.form.ContractOnlineRecordSignGoodsOwnerForm;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Base64;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.controller.ContractOnlineRecordControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 11:11
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class ContractOnlineRecordControllerTest extends BaseTestController {

    /**
     * 货主与平台的电子合同-货主签订
     **/
    @Test
    public void a1_goodsOwnerSign_success_test() throws Exception {
        String url = "/contract/online/goodsowner/sign";

        // 构造数据
        ContractOnlineRecordSignGoodsOwnerForm form = new ContractOnlineRecordSignGoodsOwnerForm();
        form.setGoodsOwnerId(4L);
        form.setBusinessNumber("DD" + System.currentTimeMillis());
        form.setGoodsName("煤炭");
        form.setGoodsTotal("5");
        form.setGoodsUnit("吨");
        form.setGoodsUnitPrice("230");
        form.setGoodsTotalPrice("1150");
        form.setDeliverAddress("辽宁沈阳市沈河区惠工街10号卓越大厦2710");
        form.setDeliverTime("2020-05-28 11:00:00");
        form.setReceiveAddress("辽宁沈阳市沈河区泉园二路85号");
        form.setReceiveTime("2020-05-28 18:00:00");
        form.setFreightCharge("500");
        form.setDepositCharge("0");
        String filepath = "D:\\test\\何锋.jpg";
        File signFile = new File(filepath);
        InputStream input = new FileInputStream(signFile);
        form.setSignData(Base64.getEncoder().encodeToString(IOUtils.toByteArray(input)));

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("contractNumber"));
    }

    /**
     * 货主与平台的电子合同-货主签订：无效的货主ID
     **/
    @Test
    @Rollback
    public void a2_goodsOwnerSign_failure_test() throws Exception {
        String url = "/contract/online/goodsowner/sign";

        // 构造数据
        ContractOnlineRecordSignGoodsOwnerForm form = new ContractOnlineRecordSignGoodsOwnerForm();
        form.setGoodsOwnerId(99999L);
        form.setBusinessNumber("DD" + System.currentTimeMillis());
        form.setGoodsName("煤炭");
        form.setGoodsTotal("5");
        form.setGoodsUnit("吨");
        form.setGoodsUnitPrice("230");
        form.setGoodsTotalPrice("1150");
        form.setDeliverAddress("辽宁沈阳市沈河区惠工街10号卓越大厦2710");
        form.setDeliverTime("2020-05-28 11:00:00");
        form.setReceiveAddress("辽宁沈阳市沈河区泉园二路85号");
        form.setReceiveTime("2020-05-28 18:00:00");
        form.setFreightCharge("500");
        form.setDepositCharge("0");
        String filepath = "D:\\test\\何锋.jpg";
        File signFile = new File(filepath);
        InputStream input = new FileInputStream(signFile);
        form.setSignData(Base64.getEncoder().encodeToString(IOUtils.toByteArray(input)));

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 根据合同编号获取合同信息
     **/
    @Test
    public void b1_getContractByNumber_success_test() throws Exception {
        String url = "/contract/online/getContractByNumber";

        // 构造数据
        ContractOnlineRecordForm form = new ContractOnlineRecordForm();
        form.setContractNumber("HZHT20200522000006");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 根据合同编号获取合同信息：无效的合同编号
     **/
    @Test
    public void b2_getContractByNumber_wrong_contractNumber_failure_test() throws Exception {
        String url = "/contract/online/getContractByNumber";

        // 构造数据
        ContractOnlineRecordForm form = new ContractOnlineRecordForm();
        form.setContractNumber("99999");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 电子合同-平台签订
     **/
    @Test
    public void c1_platformSign_success_test() throws Exception {
        String url = "/contract/online/platformSign";

        // 构造数据
        ContractOnlineRecordForm form = new ContractOnlineRecordForm();
        form.setContractNumber("HZHT20200525000002");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 电子合同-平台签订
     **/
    @Test
    @Rollback
    public void c2_platformSign_wrong_contractNumber_failure_test() throws Exception {
        String url = "/contract/online/platformSign";

        // 构造数据
        ContractOnlineRecordForm form = new ContractOnlineRecordForm();
        form.setContractNumber("99999");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }
}
