package com.esv.freight.customer.module.goodsowner.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 货主信息表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Data
public class AccountListVO implements Serializable {


	private static final long serialVersionUID = -2559918457110278351L;
	/**
	 * 
	 */
	private Long id;
	/**
	 * 创建来源：1-平台创建、2-自行注册
	 */
	private String sourceType;
	/**
	 * 货主名称（企业时为全称、个人时为联系人姓名）
	 */
	private String ownerName;
	/**
	 * 客户编码
	 */
	private String ownerNumber;
	/**
	 * 货主类型：1-个人、2-企业
	 */
	private String ownerType;
	/**
	 * 登录帐号，货主手机号
	 */
	private String account;
	/**
	 * 帐号状态：1-正常、2-停用
	 */
	private String accountStatus;
	/**
	 *
	 */
	private String createUser;
	/**
	 *
	 */
	private Long createTime;
	/**
	 * 货主帐号审核状态：0-待审核、1-审核成功，2-审核失败，APP自行注册需要平台审核
	 */
	private Integer auditStatus;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}

}
