package com.esv.freight.customer.common.util;

import com.aspose.words.Document;
import com.aspose.words.SaveFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.io.File;
import java.io.FileOutputStream;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.AsposeWordsTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/25 20:40
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class AsposeWordsTest {

    @Test
    public void word_2_pdf_time_test() {
        for (int i = 0; i < 10; i++) {
            word_2_pdf_test(i);
        }
    }

    public static void word_2_pdf_test(int i) {
        String sourcePath = "D:\\test\\线上合同-货主.docx";
        String pdfPath = "D:\\test\\线上合同-货主-test-aspose-" + (i + 1) + ".pdf";

        long old = System.currentTimeMillis();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(pdfPath));
            Document doc = new Document(sourcePath);
            doc.save(fileOutputStream, SaveFormat.PDF);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("docx文档转换为PDF失败");
        } finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
        long now = System.currentTimeMillis();
        log.info("共耗时：" + ((now - old) / 1000.0) + "秒");
    }
}
