package com.esv.freight.customer.module.pay.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 银联对账单表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-06-12 15:34:12
 */
@Data
@TableName("unionpay_statement")
public class UnionpayStatementEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 账单类型：1-手机支付控件、2-在线网关支付
	 */
	private Integer statementCategory;
	/**
	 * 对账单日期（yyyyMMdd）
	 */
	private String statementDate;
	/**
	 * 对账单压缩包文件ID
	 */
	private Long zipId;
	/**
	 * 对账单压缩包文件URL
	 */
	private String zipUrl;
	/**
	 * 对账单明细文件ID
	 */
	private Long detailId;
	/**
	 * 对账单明细文件URL
	 */
	private String detailUrl;
	/**
	 * 对账单汇总文件ID
	 */
	private Long summaryId;
	/**
	 * 对账单汇总文件URL
	 */
	private String summaryUrl;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;

}
