package com.esv.freight.customer.module.vehicle.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import com.esv.freight.customer.module.vehicle.form.VehicleInfoForm;
import com.esv.freight.customer.module.vehicle.service.VehicleService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * @description: 承运商车辆Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.vehicle.controller.VehicleController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/26 15:11
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/carrier/vehicle")
@Validated
public class VehicleController {

    private VehicleService vehicleService;

    @Autowired
    public VehicleController(VehicleService vehicleService) {
        this.vehicleService = vehicleService;
    }

    /**
     * description 新增车辆
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/26 15:17
     **/
    @PostMapping("/add")
    public EResponse insertVehicleByPlatform(@RequestBody @Validated(ValidatorInsert.class) VehicleInfoForm form) throws EException {
        /****************************** 参数校验 ******************************/
        // 总质量/整备质量不能同时为空
        if (null == form.getTotalMass() && null == form.getUnladenMass()) {
            throw new EException(ECode.PARAM_ERROR.code(), "参数totalMass|unladenMass不能同时为空");
        }
        // 道路运输证号，4.5吨及以下普货车辆可以为空
        BigDecimal bigDecimal4_5 = new BigDecimal("4.5");
        if (-1 == bigDecimal4_5.compareTo(form.getLoadCapacity()) && StringUtils.isBlank(form.getRoadCertificateNumber())) {
            throw new EException(ECode.PARAM_ERROR.code(), "4.5顿以上载重的车辆，道路运输证号不能为空");
        }
        /****************************** 参数校验 ******************************/

        Long id = vehicleService.insertVehicle(form);
        JSONObject data = new JSONObject();
        data.put("id", id);
        return EResponse.ok(data);
    }

    /**
     * description 更新车辆信息
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/27 11:05
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody @Validated(ValidatorUpdate.class) VehicleInfoForm form) throws EException {
        vehicleService.updateVehicle(form);
        return EResponse.ok();
    }
}
