package com.esv.freight.customer.module.goodsowner.dto;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 货主发货地址表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-21 15:27:27
 */
@Data
public class ReceiveAddressDto {
	/**
	 * 
	 */
	private Long id;
	/**
	 * 货主类型：1-个人、2-企业
	 */
	private String ownerType;
	/**
	 * 客户名称
	 */
	private String ownerFullName;
	/**
	 * （个人或企业）联系人
	 */
	private String contactor;
	/**
	 * 地址编码
	 */
	private String addressNumber;
	/**
	 * 地址名称
	 */
	private String addressName;
	/**
	 * 省份代码
	 */
	private String provinceCode;
	/**
	 * 市代码
	 */
	private String cityCode;
	/**
	 * 区县代码
	 */
	private String districtCode;
	/**
	 * 详细地址
	 */
	private String detailAddress;
	/**
	 * 收货人
	 */
	private String receiver;
	/**
	 * 收货人电话
	 */
	private String receiverPhone;
	/**
	 * 收货人座机
	 */
	private String receiverTelephone;
	/**
	 * 经度
	 */
	private BigDecimal lon;
	/**
	 * 纬度
	 */
	private BigDecimal lat;
	/**
	 * 是否默认收货地址：0-非默认，1-默认
	 */
	private Boolean defaultAddress;
	/**
	 * 0-未删除，1-已删除
	 */
	private Boolean deleted;
	/**
	 * 创建者
	 */
	private String createUser;
	/**
	 * 修改者
	 */
	private String updateUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

}
