package com.esv.freight.customer.module.driver.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.vo.DriverListVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/28 20:08
 * @version:1.0
 */
@Data
public class DriverListVO {

    /**
     *
     */
    private Long id;
    /**
     * 承运商名称
     */
    private String carrierName;
    /**
     * 登录帐号，司机手机号
     */
    private String account;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private Integer accountStatus;
    /**
     * 创建来源：1-平台创建、2-自行注册
     */
    private Integer sourceType;
    /**
     * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private Integer auditStatus;
    /**
     * 姓名
     */
    private String name;
    /**
     * 身份证号码
     */
    private String idCard;
    /**
     * 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
     */
    private Integer drivingLicenseType;
    /**
     * 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
     */
    private Integer certificateVehicle;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 创建时间
     */
    private Long createTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
