package com.esv.freight.customer.module.goodsowner.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.common.component.ErrorMessageComponent;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.util.FeignUtils;
import com.esv.freight.customer.feign.FeignBaseService;
import com.esv.freight.customer.module.goodsowner.dao.DeliveryAddressDao;
import com.esv.freight.customer.module.goodsowner.entity.DeliveryAddressEntity;
import com.esv.freight.customer.module.goodsowner.form.DeliveryAddressForm;
import com.esv.freight.customer.module.goodsowner.service.DeliveryAddressService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


@Service("deliveryAddressService")
public class DeliveryAddressServiceImpl extends ServiceImpl<DeliveryAddressDao, DeliveryAddressEntity> implements DeliveryAddressService {

    private FeignBaseService feignBaseService;

    private ErrorMessageComponent errorMessageComponent;

    @Autowired
    public DeliveryAddressServiceImpl(FeignBaseService feignBaseService, ErrorMessageComponent errorMessageComponent) {
        this.feignBaseService = feignBaseService;
        this.errorMessageComponent = errorMessageComponent;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long addAddress(DeliveryAddressForm form) {
        // 1.判断地址是否重复
        List<DeliveryAddressEntity> deliveryAddressEntityList = this.getAddressByName(form.getOwnerId(), form.getAddressName());
        if (0 < deliveryAddressEntityList.size()) {
            throw new EException(1001, errorMessageComponent.getGoodsOwnerDeliveryAddressAdd1001());
        }

        // 2.获取地址编码
        JSONObject batchIdReqJson = new JSONObject();
        batchIdReqJson.put("prefix", "FH");
        batchIdReqJson.put("formatter", "yyyyMMdd");
        batchIdReqJson.put("length", 13);
        JSONObject batchIdResJson;
        try {
            batchIdResJson = FeignUtils.getFeignResultData(feignBaseService.getBatchId(batchIdReqJson));
        } catch (Exception e) {
            log.error("调用[基础服务]生成发货地址编号失败");
            throw new EException("生成发货地址编号时发生错误");
        }
        String addressNumber = batchIdResJson.getString("batchId");

        // 3.新增地址
        DeliveryAddressEntity addressEntity = new DeliveryAddressEntity();
        BeanUtils.copyProperties(form, addressEntity);
        addressEntity.setAddressNumber(addressNumber);
        this.baseMapper.insert(addressEntity);

        return addressEntity.getId();
    }

    @Override
    public List<DeliveryAddressEntity> getAddressByName(Long ownerId, String addressName) {
        QueryWrapper<DeliveryAddressEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("owner_id", ownerId);
        queryWrapper.eq("address_name", addressName);
        return this.getBaseMapper().selectList(queryWrapper);
    }
}