package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.goodsowner.form.RegularlyRouteForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.DeliveryAddressControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/21 16:57
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class RegularlyRouteControllerTest extends BaseTestController {

    /**
     * 新增常跑线路
     **/
    @Test
    public void a1_add_success_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连线路");
        form.setDeliveryId(7L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增常跑线路：名称重复
     **/
    @Test
    @Rollback
    public void a2_add_failure_repeat_name_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连线路");
        form.setDeliveryId(7L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 新增常跑线路：无效的货主ID
     **/
    @Test
    @Rollback
    public void a3_add_failure_repeat_name_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(99999L);
        form.setRouteName("沈阳-大连线路111");
        form.setDeliveryId(7L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 新增常跑线路：无效的发货地址ID
     **/
    @Test
    @Rollback
    public void a4_add_failure_wrong_delivery_id_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连线路111");
        form.setDeliveryId(99999L);
        form.setReceiveId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 新增常跑线路：无效的收货地址ID
     **/
    @Test
    @Rollback
    public void a5_add_failure_wrong_receive_id_test() throws Exception {
        String url = "/goodsowner/regularly/route/add";

        // 构造数据
        RegularlyRouteForm form = new RegularlyRouteForm();
        form.setOwnerId(1L);
        form.setRouteName("沈阳-大连线路111");
        form.setDeliveryId(7L);
        form.setReceiveId(99999L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

}
