package com.esv.freight.customer.module.goodsowner.form;

import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.form.RegularlyRouteForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 16:11
 * @version:1.0
 */
@Data
public class RegularlyRouteForm {

//    @NotNull(message = "参数id不能为空")
    private Long id;

    @Length(max = 50, message = "参数routeName长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数routeName不能为空", groups = {ValidatorInsert.class})
    private String routeName;

    @NotNull(message = "参数ownerId不能为空", groups = {ValidatorInsert.class})
    private Long ownerId;

    @NotNull(message = "参数deliveryId不能为空", groups = {ValidatorInsert.class})
    private Long deliveryId;

    @NotNull(message = "参数receiveId不能为空", groups = {ValidatorInsert.class})
    private Long receiveId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
